#version 130
#extension GL_EXT_gpu_shader4 : enable
// the version and open GL extension
// should be the first line of the shader
/////////////////////////////////////////////////////////////////////////////////
// Neon Pulse KrakenMod01.fsh   by     nilberlin 
//https://www.shadertoy.com/view/lXXfRM
//Licence : Creative Commons Attribution-ShareAlike 4.0
//http://creativecommons.org/licences/by-sa/4.0
// Adapted, trivialy, for use in VGHD player
/////////////////////////////////////////////
uniform float u_Elapsed;    // The elapsed time in seconds
uniform vec2  u_WindowSize; // Window dimensions in pixels

#define iTime u_Elapsed*0.314159  //*0.1666
#define iResolution u_WindowSize

//#define mouse AUTO_MOUSE
//#define MOUSE_SPEED vec2(vec2(0.5,0.577777) * 0.25)
//#define MOUSE_POS   vec2((1.0+cos(iTime*MOUSE_SPEED))*u_WindowSize/2.0)
//#define MOUSE_PRESS vec2(0.0,0.0)
//#define AUTO_MOUSE  vec4( MOUSE_POS, MOUSE_PRESS )
//#define RIGID_SCROLL
// alternatively use static mouse definition
#define iMouse vec4(0.0,0.0, 0.0,0.0)
//#define iMouse vec4(512,256,180,120)
uniform sampler2D texture0;
uniform sampler2D texture1;
uniform sampler2D texture2;
uniform sampler2D texture3;
vec4 texture2D_Fract(sampler2D sampler,vec2 P) {return texture2D(sampler,fract(P));}
vec4 texture2D_Fract(sampler2D sampler,vec2 P, float Bias) {return texture2D(sampler,fract(P),Bias);}
#define texture2D texture2D_Fract

//void mainImage( out vec4 fragColor, in vec2 fragCoord )
///////////////////////////////////////////////////////////////////////////////// 
// need to convert this from a void to a function and call it by adding
// a void main(void) { to the end of the shader
// what type of variable will the function return?, it is a color and needs to be a vec4
// change void to vec4 
//void MainImage(out vec4 fragColor, in vec2 fragCoord) 
vec4 mainImage( out vec4 fragColor, in vec2 fragCoord )
{ 
    vec2 uv = fragCoord.xy / iResolution.xy - 0.5;
    uv.x *= iResolution.x / iResolution.y;

    float time = iTime * 0.5;

    // Octopus body and arms with more variation
    float angle = atan(uv.y, uv.x);
    float radius = length(uv);
    float armPattern = sin(12.0 * angle + time * 4.0 - radius * 10.0);

    // Add more rhythmic wave-like movement to the arms
    float waveMovement = sin(time * 1.5 + radius * 5.0 + angle * 3.0) * cos(time * 2.0 - angle * 4.0);
    armPattern += 0.1 * waveMovement;

    // Add reverse movement for more dynamic variation
    float reverseWave = cos(time * 2.0 - radius * 3.0 - angle * 2.0);
    armPattern += 0.05 * reverseWave;

    // Create dots for tentacles (suckers) with additional variation
    float dotPattern = smoothstep(0.015, 0.035, cos(radius * 40.0 + armPattern * 6.0 + waveMovement));

    // Color shifting to introduce a 7-second full color change with neon colors
    float colorCycle = mod(floor(iTime / 7.0), 6.0);
    vec3 baseColor;
    if (colorCycle == 0.0) baseColor = vec3(1.0, 0.0, 0.5); // Neon Pink
    else if (colorCycle == 1.0) baseColor = vec3(0.0, 1.0, 0.5); // Neon Green
    else if (colorCycle == 2.0) baseColor = vec3(0.0, 0.5, 1.0); // Neon Blue
    else if (colorCycle == 3.0) baseColor = vec3(1.0, 1.0, 0.0); // Neon Yellow
    else if (colorCycle == 4.0) baseColor = vec3(1.0, 0.5, 0.0); // Neon Orange
    else baseColor = vec3(0.5, 0.0, 1.0); // Neon Purple

    // Color modulation based on armPattern and sound input for more dynamic hues
    float sound = texture2D(texture0, vec2(angle * 0.1 + time * 0.05, 0.5)).r;
    vec3 color = baseColor * (0.7 + 0.3 * sin(armPattern * 12.0 + time * 1.5 + sound * 5.0));

    // Introduce pulsing and elasticity effect to make the entire mass feel elastic
    float elasticity = 0.05 * sin(time * 2.0 + radius * 8.0 + sound * 10.0);
    armPattern += elasticity;

    // Apply dot pattern to simulate tentacle suckers
    color *= dotPattern;

    // Add glow effect with more dynamic range
    float glow = smoothstep(0.1, 0.25, armPattern + waveMovement * 0.5);
    color += glow * 0.5;

    // Add a stronger pulsing effect synced with the beat
    float beatPulse = 0.4 * sin(iTime * 3.0 + radius * 10.0 + sound * 15.0);
    color += beatPulse;

    // Add more rhythmic and opposing movement effects
    float rhythmEffect = 0.2 * sin(time * 4.0 + radius * 4.0) * cos(time * 2.5 - radius * 5.0);
    color += rhythmEffect;

    // Final blending for the octopus effect, enhancing brightness and contrast
    color = pow(color, vec3(1.4)); // Increase contrast slightly for more punch
    fragColor = vec4(color, 1.0);
/////////////////////////////////////////////////////////////////////////////////
//the function needs to return a value. 
//it needs to be a vec4
//we will return the varable fragColor 
// usual place for fragColor = vec4( color, 1.0 ); bring the } down below 
return fragColor; 
}

///////////////////////////////////////////////////////////////////////////////// 
void main(void) { // this will be run for every pixel of gl_FragCoord.xy
vec4 vTexCoord = gl_TexCoord[0];
vec4 fragColor = vec4(1.0); // initialize variable fragColor as a vec4 
vec4 cc = mainImage(fragColor, gl_FragCoord.xy); // call function mainImage and assign the return vec4 to cc
gl_FragColor = vec4(cc) * gl_Color; // set the pixel to the value of vec4 cc  and..
//gl_FragColor.a = length(gl_FragColor.rgb);
}

// ..uses the values of any Color: or Opacity:
// clauses (and any Animate clauses applied to these properties) 
// appearing in the Sprite, Quad or other node invoking the shader 
// in the .scn file.

